#!/bin/sh

#
# Gather various system information
#

mkdir -p /tmp/system-info

# OS release
mkdir -p /tmp/system-info/etc
cp /etc/*version* /etc/*release* /tmp/system-info/etc || true

# Hardware list
mkdir -p /tmp/system-info/hardware
lshw -html > /tmp/system-info/hardware/lshw.html || true

# Kernel version
mkdir -p /tmp/system-info/kernel
uname -a > /tmp/system-info/kernel/uname_a.txt || true

# Display Manager
mkdir -p /tmp/system-info/display-manager
cp /etc/X11/default-display-manager /tmp/system-info/display-manager || true
cp /etc/systemd/system/display-manager.service /tmp/system-info/display-manager || true
systemctl status display-manager.service > /tmp/system-info/display-manager/display-manager_status.txt || true

# NetworkManager service journal
mkdir -p /tmp/system-info/journals
journalctl --unit=NetworkManager > /tmp/system-info/journals/NetworkManager.txt || true

# SRStreamer service journal
journalctl --unit=SRStreamer > /tmp/system-info/journals/SRStreamer.txt || true

#
# Systemd login manager
#
mkdir -p /tmp/system-info/systemd-login-manager/seats
mkdir -p /tmp/system-info/systemd-login-manager/users
mkdir -p /tmp/system-info/systemd-login-manager/sessions
mkdir -p /tmp/system-info/systemd-login-manager/sessions/journals

# Systemd login manager - seats
loginctl list-seats > /tmp/system-info/systemd-login-manager/seats/list-seats.txt || true
for seat in $(loginctl list-seats --no-legend); do \
    loginctl seat-status $seat > /tmp/system-info/systemd-login-manager/seats/seat-status-$seat.txt || true
done

# Systemd login manager - sessions
loginctl list-sessions > /tmp/system-info/systemd-login-manager/sessions/list-sessions.txt || true
loginctl session-status > /tmp/system-info/systemd-login-manager/sessions/session-status.txt || true
for session in $(loginctl list-sessions --no-legend | awk '{ print $1 }'); do \
    loginctl show-session $session > /tmp/system-info/systemd-login-manager/sessions/session-$session.txt || true; \
    journalctl --unit=session-$session.scope > /tmp/system-info/systemd-login-manager/sessions/journals/session-$session.scope.txt || true; \
done

# Systemd login manager - users
loginctl list-users > /tmp/system-info/systemd-login-manager/users/list-users.txt || true
loginctl user-status > /tmp/system-info/systemd-login-manager/users/user-status.txt || true
for user in $(loginctl list-users --no-legend | awk '{ print $2 }'); do \
    loginctl show-user $user > /tmp/system-info/systemd-login-manager/users/user-$user.txt || true; \
done

#
# Compress the files as system-info.tar.bz2
#
tar -C /tmp -cjf system-info.tar.bz2 system-info || true
rm -rf /tmp/system-info
