#!/bin/bash

# $substr: user, name, class, type, display
substr=$(
for sessionid in $(loginctl list-sessions --no-legend | awk '{ print $1 }')
do loginctl show-session -p Id -p Name -p User -p State -p Class -p Type -p Remote -p Display -p Seat $sessionid | sort
done |
awk -F= '/Name/ { name = $2 } /User/ { user = $2 } /State/ { state = $2 } /Class/ { class = $2 } /Type/ { type = $2 } /Remote/ { remote = $2 } /Display/ { display = $2 } /Seat/ { seat = $2 } /User/ && remote == "no" && state == "active" && (type == "x11" || type == "wayland") && seat == "seat0" { print user, name, class, type, display }'
)

if [ ! -z $1 ] && [ "-uid" == $1 ]; then
	Uid="UID="$(echo $substr | cut -d" " -f 1)
	echo $Uid;
	exit 0
fi
if [ ! -z $1 ] && [ "-auth" == $1 ]; then
	AuthPath="XAUPATH=/var/run/sddm/"$(ls /var/run/sddm/)
	echo $AuthPath;
	exit 0
fi

Uid="UID="$(echo $substr | cut -d" " -f 1)
User="USER="$(echo $substr | cut -d" " -f 2)
Class="CLASS="$(echo $substr | cut -d" " -f 3)
Type="TYPE="$(echo $substr | cut -d" " -f 4)
Display="DISPLAY="$(echo $substr | cut -d" " -f 5)
OSName=$(cat /etc/os-release | sed -n -e 's/^\s*NAME\s*=\s*//p')
OSVersion=$(cat /etc/os-release | sed -n -e 's/^\s*VERSION_ID\s*=\s*//p')

if [[ $OSName == *"Ubuntu"* ]]; then
	if [[ $OSVersion != *"16.04"* ]]; then
		if [ $User != "USER=gdm" ] && [ $User != "USER=lightdm" ]; then
			DisplayID=`w -h $(echo $substr | cut -d" " -f 2) | awk '$3 ~ /:[0-9.]*/{print $3}'`
			Display="DISPLAY="$DisplayID
		fi
	fi
elif [[ $OSName == *"Fedora"* ]]; then
	if [ $User != "USER=gdm" ] && [ $User != "USER=lightdm" ]; then
		DisplayID=`w -h $(echo $substr | cut -d" " -f 2) | awk '$2 ~ /:[0-9.]*/{print $2}'`
		Display="DISPLAY="$DisplayID
	fi
elif [[ $OSName == *"Red Hat Enterprise Linux"* ]]; then
	if [[ $OSVersion == *"8."* ]]; then
		if [ $User != "USER=gdm" ]; then
			DisplayID=`w -h $(echo $substr | cut -d" " -f 2) | awk '$3 ~ /:[0-9.]*/{print $2}'`
			Display="DISPLAY="$DisplayID
		fi
	fi
elif [[ $OSName == *"CentOS Linux"* ]]; then
	if [[ $OSVersion == *"8"* ]]; then
		if [ $User != "USER=gdm" ]; then
			DisplayID=`w -h $(echo $substr | cut -d" " -f 2) | awk '$3 ~ /:[0-9.]*/{print $2}'`
			Display="DISPLAY="$DisplayID
		fi
	fi
fi

echo $Uid
echo $Display
echo $User
echo $Type
echo $Class

exit 0
